/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.core;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.AnimatableProperty;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.HorizontalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Surface;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.VerticalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.IncompatibleUIModelException;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.ScissorStack;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public interface ParentComponent
extends ModComponent {
    public void layout(Size var1);

    public void onChildMutated(ModComponent var1);

    public void queue(Runnable var1);

    default public ParentComponent alignment(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.horizontalAlignment(horizontalAlignment);
        this.verticalAlignment(verticalAlignment);
        return this;
    }

    public ParentComponent verticalAlignment(VerticalAlignment var1);

    public VerticalAlignment verticalAlignment();

    public ParentComponent horizontalAlignment(HorizontalAlignment var1);

    public HorizontalAlignment horizontalAlignment();

    public ParentComponent padding(Insets var1);

    public AnimatableProperty<Insets> padding();

    public ParentComponent allowOverflow(boolean var1);

    public boolean allowOverflow();

    public ParentComponent surface(Surface var1);

    public Surface surface();

    public List<ModComponent> children();

    public ParentComponent removeChild(ModComponent var1);

    @Override
    default public void drawTooltip(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        ModComponent.super.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
        if (!this.allowOverflow()) {
            Insets padding = (Insets)this.padding().get();
            ScissorStack.push(this.x() + padding.left(), this.y() + padding.top(), this.width() - padding.horizontal(), this.height() - padding.vertical(), matrices);
        }
        for (ModComponent child : this.children()) {
            if (!ScissorStack.isVisible(mouseX, mouseY, matrices)) continue;
            matrices.m_85837_(0.0, 0.0, (double)child.zIndex());
            child.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
            matrices.m_85837_(0.0, 0.0, (double)(-child.zIndex()));
        }
        if (!this.allowOverflow()) {
            ScissorStack.pop();
        }
    }

    @Override
    default public boolean onMouseDown(double mouseX, double mouseY, int button) {
        ListIterator<ModComponent> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            ModComponent child = iter.previous();
            if (!child.isInBoundingBox((double)this.x() + mouseX, (double)this.y() + mouseY) || !child.onMouseDown((double)this.x() + mouseX - (double)child.x(), (double)this.y() + mouseY - (double)child.y(), button)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        ListIterator<ModComponent> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            ModComponent child = iter.previous();
            if (!child.isInBoundingBox((double)this.x() + mouseX, (double)this.y() + mouseY) || !child.onMouseScroll((double)this.x() + mouseX - (double)child.x(), (double)this.y() + mouseY - (double)child.y(), amount)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public void update(float delta, int mouseX, int mouseY) {
        ModComponent.super.update(delta, mouseX, mouseY);
        this.padding().update(delta);
        for (ModComponent child : this.children()) {
            child.update(delta, mouseX, mouseY);
        }
    }

    @Override
    default public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        ModComponent.super.parseProperties(model, element, children);
        UIParsing.apply(children, "padding", Insets::parse, this::padding);
        UIParsing.apply(children, "surface", Surface::parse, this::surface);
        UIParsing.apply(children, "vertical-alignment", VerticalAlignment::parse, this::verticalAlignment);
        UIParsing.apply(children, "horizontal-alignment", HorizontalAlignment::parse, this::horizontalAlignment);
        UIParsing.apply(children, "allow-overflow", UIParsing::parseBool, this::allowOverflow);
    }

    @Nullable
    default public <T extends AbstractWidget> T childByIdOther(@NotNull Class<T> expectedClass, @NotNull String id) {
        ListIterator<ModComponent> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            ParentComponent parent;
            T candidate;
            ModComponent child = iter.previous();
            if (Objects.equals(child.id(), id)) {
                if (!expectedClass.isAssignableFrom(child.getClass())) {
                    throw new IncompatibleUIModelException("Expected child with id '" + id + "' to be a " + expectedClass.getSimpleName() + " but it is a " + child.getClass().getSimpleName());
                }
                return (T)((AbstractWidget)child);
            }
            if (!(child instanceof ParentComponent) || (candidate = (parent = (ParentComponent)child).childByIdOther(expectedClass, id)) == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    default public <T extends ModComponent> T childById(@NotNull Class<T> expectedClass, @NotNull String id) {
        ListIterator<ModComponent> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            ParentComponent parent;
            T candidate;
            ModComponent child = iter.previous();
            if (Objects.equals(child.id(), id)) {
                if (!expectedClass.isAssignableFrom(child.getClass())) {
                    throw new IncompatibleUIModelException("Expected child with id '" + id + "' to be a " + expectedClass.getSimpleName() + " but it is a " + child.getClass().getSimpleName());
                }
                return (T)child;
            }
            if (!(child instanceof ParentComponent) || (candidate = (parent = (ParentComponent)child).childById(expectedClass, id)) == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    default public ModComponent childAt(int x, int y) {
        ListIterator<ModComponent> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            ModComponent child = iter.previous();
            if (!child.isInBoundingBox(x, y)) continue;
            if (child instanceof ParentComponent) {
                ParentComponent parent = (ParentComponent)child;
                return parent.childAt(x, y);
            }
            return child;
        }
        return this.isInBoundingBox(x, y) ? this : null;
    }

    default public void collectChildren(ArrayList<ModComponent> into) {
        into.add(this);
        for (ModComponent child : this.children()) {
            if (child instanceof ParentComponent) {
                ParentComponent parent = (ParentComponent)child;
                parent.collectChildren(into);
                continue;
            }
            into.add(child);
        }
    }
}

